// lib/service.js
const nodemailer = require('nodemailer');
const config = require('../config/config');

const transporter = nodemailer.createTransport({
    host: 'srv2.hostreloaded.com',
    port: 465, // SMTP secure port
    secure: true, // true for port 465, false for 587
    auth: {
      user: config.MAIL_USER, // e.g. info@ugbowomegafair.com
      pass: config.MAIL_PASS  // your email password or generated SMTP password
    }
});

exports.sendRegistrationEmail = async ({
  firstName,
  surname,
  businessName,
  cacRegistered,
  slotOption,
  photo
}) => {
  const photoUrl = `${config.BASE_URL || 'https://ugbowomegafair.com'}/uploads/${photo}`;

  const mailOptions = {
    from: `"Ugbowo Fair Bot" <${config.MAIL_USER}>`,
    to: 'info@ugbowomegafair.com',
    subject: `New Registration - ${businessName}`,
    html: `
      <h3>New Vendor Registered</h3>
      <p><strong>Name:</strong> ${firstName} ${surname}</p>
      <p><strong>Business:</strong> ${businessName}</p>
      <p><strong>CAC Registered:</strong> ${cacRegistered}</p>
      <p><strong>Slot Option:</strong> ${slotOption}</p>
      <p><strong>Photo Proof:</strong> <a href="${photoUrl}" target="_blank">View Uploaded Photo</a></p>
      <br />
      <img src="${photoUrl}" alt="Uploaded Proof" style="max-width: 300px; border: 1px solid #ddd; padding: 5px;" />
    `
  };

  return transporter.sendMail(mailOptions);
};
