const express = require('express');
const multer = require('multer');
const path = require('path');
const { handleFormSubmission } = require('../controllers/formController');

const router = express.Router();

// Set up multer
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'uploads/');
  },
  filename: function (req, file, cb) {
    const uniqueName = `${Date.now()}-${file.originalname}`;
    cb(null, uniqueName);
  }
});

const upload = multer({ storage });

// Form submission route with image
router.post('/', upload.single('photo'), handleFormSubmission);

module.exports = router;
